//=============================================================================

/*:
 * @plugindesc オプションメニューに『ゲーム終了』コマンドを追加します
 * 
 * @author LefTonbo
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_GameEndInOption = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// Window_Options
//=============================================================================

var _Window_Options_makeCommandList = Window_Options.prototype.makeCommandList;
Window_Options.prototype.makeCommandList = function() {
  _Window_Options_makeCommandList.call(this);
  this.addCommand(TextManager.gameEnd, 'gameEnd', true);
};

var _Window_Options_drawItem = Window_Options.prototype.drawItem;
Window_Options.prototype.drawItem = function(index) {
  if (this.commandSymbol(index) === 'gameEnd') {
    var rect = this.itemRectForText(index);
    var text = this.commandName(index);
    this.changeTextColor(this.crisisColor());
    this.changePaintOpacity(this.isCommandEnabled(index));
    this.drawText(text, rect.x, rect.y, rect.width, 'left');
  } else {
    _Window_Options_drawItem.call(this, index);
  }
};

var _Window_Options_processOk = Window_Options.prototype.processOk;
Window_Options.prototype.processOk = function() {
  if (this.commandSymbol(this.index()) === 'gameEnd') {
    Window_Command.prototype.processOk.call(this);
  } else {
    _Window_Options_processOk.call(this);
  }
};

//=============================================================================
// Scene_Options
//=============================================================================

var _Scene_Options_createOptionsWindow = Scene_Options.prototype.createOptionsWindow;
Scene_Options.prototype.createOptionsWindow = function() {
  _Scene_Options_createOptionsWindow.call(this);
  this._optionsWindow.setHandler('gameEnd', this.commandGameEnd.bind(this));
};

Scene_Options.prototype.commandGameEnd = function() {
  SceneManager.push(Scene_GameEnd);
};

//=============================================================================

})();

// EOF
